#######################################################################
# R code: Example 6.4
# File: estimate-new.r
#
# Coded by David Ubilava
#
# The complete set of R codes consists of 3 parts: 
# 'estimate-new', 'forecast-new.r', 'outofsample-new.r' 
# The programs should be run in that sequence (each code uses some data
# from the previous one).
#######################################################################
## setting the working directory
setwd("C:/.../R-Codes_EMS")    # home directory

# seting the memory size
memory.limit(size=2^12-1)

# loading packages
library(tseries)
library(xtable)
library(vars)
library(moments)
library(reshape)

# uploading functions
source("Functions/adf.boot.r")
source("Functions/dummy.r")
source("Functions/startest.r")
source("Functions/star.r")

# uploading data from the NOAA website
ensodat <- read.table("http://www.cpc.ncep.noaa.gov/data/indices/ersst3b.nino.mth.ascii",header=TRUE)

# data management
SSTA <- as.matrix(ensodat[,10])
enso.f <- as.matrix(SSTA)

n <- nrow(SSTA)

styr <- ensodat[1,1]
stmn <- ensodat[1,2]

enyr <- ensodat[n,1]
enmn <- ensodat[n,2]

enso.ts <- ts(enso.f,start=c(styr,stmn),end=c(enyr,enmn),frequency=12)

nmax <- round(n/12)*12
tmax <- round((nmax/12)*(2/3))*12

hor <- 36

## for the full set of data
yrmax <- (nmax-tmax-hor)/12

## for four years only, to test if the code works
#yrmax <- 4 # need to comment-out this line when running the full set of estimations

momax  <- 12

# create a matrix of dummy variables
dum <- dummy(n,12,1)[(1):(n),]

for(d in 1:yrmax){      # start main loop A
for(m in 1:momax){      # start main loop B

z <- (d-1)*momax+(m-1)

enso <- as.matrix(enso.f[(1):(tmax+z),])

# total number of observations
n.e <- nrow(enso) # also equal to n
l.e <- 24 # maximum lag length

# creating matrix of dummy variables
dum.mat <- dum[((1)+l.e):(tmax+z),]

# testing for stationarity
if(m == 1){
adf.e <- adf.boot(enso,l.e,crit="SC")
p.e <- min(12,adf.e$optlag)  # optimal lag length in levels (trimmed at 12)
}else{
p.e <- p.e  
}  
p.e <- 6

enso.d <- as.matrix(diff(enso))
n.e.d <- n.e-1
l.e.d <- l.e-1
p.e.d <- p.e-1

# creating a matrix of lagged enso variable
l.enso.mat <- matrix(0,(n.e-l.e),l.e)
for (i in 1:(n.e-l.e)){
  for (j in 1:l.e){
    l.enso.mat[i,j] <- enso[(l.e+i+1-j),1]
  }
}

# creating a matrix of lagged differenced enso
l.enso.d.mat <- matrix(0,(n.e.d-l.e.d),l.e.d)
for (i in 1:(n.e.d-l.e.d)){
  for (j in 1:l.e.d){
    l.enso.d.mat[i,j] <- enso.d[(l.e.d+i+1-j),1]
  }
}

# creating a vector of dependent and a matrix of independent variables
enso.dep <- as.matrix(l.enso.d.mat[,1])

enso.l <- as.matrix(l.enso.mat[,2])
enso.d.mat <- as.matrix(l.enso.d.mat[,2:p.e])
enso.ind <- cbind(1,enso.l,enso.d.mat,dum.mat)

# linear regression estimates
b.ar <- crossprod(solve(crossprod(enso.ind)),crossprod(enso.ind,enso.dep))
resid.ar <- enso.dep - enso.ind%*%b.ar
ssr.ar <- crossprod(resid.ar)
sigma.ar <- ssr.ar/n.e
aic.ar <- log(sigma.ar)+2*nrow(b.ar)/n.e
aic.ar2 <- n.e*log(sigma.ar)+2*nrow(b.ar)

# testing nonlinearities
trans.var.enso <- enso

ter.e  <- terasvirta.test(y=enso.dep,x=enso.ind,x.nl=enso.ind,tv.lag=6,tv=trans.var.enso,ascending=F,ac.lag=6)
ac.mat <- ter.e$ac.mat

nlin.e <- as.matrix(ter.e$nl.mat[,1:4])
nlin.e.tab <- xtable(nlin.e)

nl.vec <- as.matrix(as.numeric(nlin.e[,1]))
d.vec  <- as.matrix(c(1:6))
d.mat  <- cbind(d.vec,nl.vec)
d.ord  <- d.mat[do.call("order",as.data.frame(d.mat[,2])),]

if(m == 1){    # start 1 
  d.i <- 0
  repeat{      # start 2
  
  ac.stop=1
  brk <- "no"
  d.i <- d.i+1
  d.e <- d.ord[d.i,1]
  s.e <- as.matrix(trans.var.enso[(25-d.e):(nrow(trans.var.enso)-d.e),1])
  c.e <- mean(s.e)
  f.e <- "l"

  reslin.e <- gridsearch(y=enso.dep,x=enso.ind,x.nl=enso.ind,tv=s.e,model=f.e,g.max=50,alpha=0.20)
  x.e.0 <- as.matrix(reslin.e$params)
  g.e.0 <- as.matrix(reslin.e$ghat)
  c.e.0 <- x.e.0[length(x.e.0)]

  if(g.e.0 >= 50){    # start 3
    g.0 <- 100
  }else{              # end 3, start 4 
    g.0 <- NULL
  }                   # end 4 

  if((g.e.0 > 5) & ((c.e.0 >= quantile(s.e,0.25)) & (c.e.0 <= quantile(s.e,0.75)))){  # start 5
   res.star    <- nlm(star,x.e.0,hessian=TRUE,gradtol=1e-8,stepmax=1000,steptol=1e-6,iterlim=1000,dep=enso.dep,indep=enso.ind,indep.nl=enso.ind,tind=s.e,model=f.e,ghat=g.0)
   b.star      <- as.matrix(res.star$estimate)
  
   c.i <- as.matrix(b.star[nrow(b.star),])
   if(is.null(g.0)){  # start 6
    g.i <- as.matrix(b.star[(nrow(b.star)-1),])
   }else{             # end 6, start 7
     g.i <- 100
   }                  # end 7 
  
   if((g.i > 5) & ((c.i >= quantile(s.e,0.25)) & (c.i <= quantile(s.e,0.75)))){ # start 8
     break
   }else if((g.i > 1.0) & ((c.i >= quantile(s.e,0.15)) & (c.i <= quantile(s.e,0.85)))){ # end 8, start 9
     break
   }                  # end 9
  
   fit.star    <- star.pred(b.star,enso.dep,enso.ind,enso.ind,s.e,model=f.e,ghat=g.0)
   resid.star  <- fit.star$resid
   trans.star  <- fit.star$trans
  
   trans.e.mat <- cbind(s.e,trans.star)
   trans.e.ord <- trans.e.mat[do.call("order",as.data.frame(trans.e.mat[,1])),]
  
   b.e.1 <- b.star[(1):(2+p.e.d+11)]
   b.e.2 <- b.star[((2+p.e.d+11)+1):(2*(2+p.e.d+11))]
   if(is.null(g.0)){  # start 10
    g.e   <- b.star[(2*(2+p.e.d+11)+1)]
    c.e   <- b.star[(2*(2+p.e.d+11)+2)]
   }else{             # end 10, start 11
    g.e   <- 100
    c.e   <- b.star[(2*(2+p.e.d+11)+1)]
   }                  # end 11
   
   # remaining nonlinearity
   y0 <- resid.star
   trans <- trans.star
   tind.star <- s.e
   sdtr <- apply(tind.star,2,sd)
   ggt  <- ((1+exp(-(g.e/sdtr)*(tind.star-c.e)))^(-2))*(exp(-(g.e/sdtr)*(tind.star-c.e)))*((tind.star-c.e)/sdtr)
   gct  <- ((1+exp(-(g.e/sdtr)*(tind.star-c.e)))^(-2))*(exp(-(g.e/sdtr)*(tind.star-c.e)))*(g.e/sdtr)
   Xb   <- (enso.ind*matrix(trans,nrow(enso.ind),ncol(enso.ind)))
   Xg   <- (enso.ind*matrix(ggt,nrow(enso.ind),ncol(enso.ind)))%*%(b.e.2)
   Xc   <- (enso.ind*matrix(gct,nrow(enso.ind),ncol(enso.ind)))%*%(b.e.2)
  
   if(g.e < 15){    # start 12
    exog.mat.2 <- cbind(enso.ind,Xb,Xg,Xc)
   }else{           # end 12,start 13
    exog.mat.2 <- cbind(enso.ind,Xb)
   }                # end 13 
  
   ter.e.2  <- terasvirta.test(y=y0,x=exog.mat.2,x.nl=enso.ind,tv=trans.var.enso,tv.lag=6,ascending=F)
  
   nl.mat.2 <- as.numeric(as.matrix(ter.e.2$nl.mat[,1]))
   ac.mat.2 <- as.numeric(as.matrix(ter.e.2$ac.mat[,1]))
  
   if((any(ac.mat.2 < 0.01) | any(nl.mat.2 < 0.001))){   # start 14
    ac.stop <- 1
   }else{                                                # end 14, start 15
    ac.stop <- 0
   }                                                     # end 15
    
}else if((g.e.0 > 1.0) & ((c.e.0 >= quantile(s.e,0.15)) & (c.e.0 <= quantile(s.e,0.85)))){  # end 5, start 16
  
  res.star    <- nlm(star,x.e.0,hessian=TRUE,gradtol=1e-8,stepmax=1000,steptol=1e-6,iterlim=1000,dep=enso.dep,indep=enso.ind,indep.nl=enso.ind,tind=s.e,model=f.e,ghat=g.0)
  b.star      <- as.matrix(res.star$estimate)
  
  c.i <- as.matrix(b.star[nrow(b.star),])  
  if(is.null(g.0)){                                      # start 17
    g.i <- as.matrix(b.star[(nrow(b.star)-1),])
  }else{                                                 # end 17, start 18 
    g.i <- 100       
  }                                                      # end 18 
  
  if((g.i > 5) & ((c.i >= quantile(s.e,0.25)) & (c.i <= quantile(s.e,0.75)))){  # start 19
    brk <- "yes"
  }else if((g.i > 1.0) & ((c.i >= quantile(s.e,0.15)) & (c.i <= quantile(s.e,0.85)))){  # end 19, start 20
    brk <- "yes"
  }                                                      # end 20 
  
  fit.star    <- star.pred(b.star,enso.dep,enso.ind,enso.ind,s.e,model=f.e,ghat=g.0)
  resid.star  <- fit.star$resid
  trans.star  <- fit.star$trans
    
  trans.e.mat <- cbind(s.e,trans.star)
  trans.e.ord <- trans.e.mat[do.call("order",as.data.frame(trans.e.mat[,1])),]
    
  b.e.1 <- b.star[(1):(2+p.e.d+11)]
  b.e.2 <- b.star[((2+p.e.d+11)+1):(2*(2+p.e.d+11))]
  if(is.null(g.0)){                                       # start 21                  
    g.e   <- b.star[(2*(2+p.e.d+11)+1)]
    c.e   <- b.star[(2*(2+p.e.d+11)+2)]
  }else{                                                  # end 21, start 22
    g.e   <- 100
    c.e   <- b.star[(2*(2+p.e.d+11)+1)]
  }                                                       # end 22  
  
  # remaining nonlinearity
  y0 <- resid.star
  trans <- trans.star
  tind.star <- s.e
  sdtr <- apply(tind.star,2,sd)
  ggt  <- ((1+exp(-(g.e/sdtr)*(tind.star-c.e)))^(-2))*(exp(-(g.e/sdtr)*(tind.star-c.e)))*((tind.star-c.e)/sdtr)
  gct  <- ((1+exp(-(g.e/sdtr)*(tind.star-c.e)))^(-2))*(exp(-(g.e/sdtr)*(tind.star-c.e)))*(g.e/sdtr)
  Xb   <- (enso.ind*matrix(trans,nrow(enso.ind),ncol(enso.ind)))
  Xg   <- (enso.ind*matrix(ggt,nrow(enso.ind),ncol(enso.ind)))%*%(b.e.2)
  Xc   <- (enso.ind*matrix(gct,nrow(enso.ind),ncol(enso.ind)))%*%(b.e.2)
  
  if(g.e < 15){                                            # start 23
    exog.mat.2 <- cbind(enso.ind,Xb,Xg,Xc)
  }else{                                                   # end 23, start 24
    exog.mat.2 <- cbind(enso.ind,Xb)           
  }                                                        # end 24
  
  ter.e.2 <- terasvirta.test(y=y0,x=exog.mat.2,x.nl=enso.ind,tv=trans.var.enso,tv.lag=6,ascending=F)
  
  nl.mat.2 <- as.numeric(as.matrix(ter.e.2$nl.mat[,1]))
  ac.mat.2 <- as.numeric(as.matrix(ter.e.2$ac.mat[,1]))
  
  if((any(ac.mat.2 < 0.01) | any(nl.mat.2 < 0.0005))){     # start 25
    ac.stop <- 1
  }else{                                                   # end 25, start 26  
    ac.stop <- 0
  }                                                        # end 26
    
}                                                          # end 16
   
  if((ac.stop==0) & (brk=="yes"))break                     
  if((d.i==6))break    

}                                                          # end 2

}else{                                                     # end 1, start 27
  d.e <- d.e
  s.e <- as.matrix(trans.var.enso[(25-d.e):(nrow(trans.var.enso)-d.e),1])
  c.e <- mean(s.e)
  f.e <- "l"

  reslin.e <- gridsearch(y=enso.dep,x=enso.ind,x.nl=enso.ind,tv=s.e,model=f.e,g.max=50,alpha=0.15)
  x.e.0 <- as.matrix(reslin.e$params)
  g.e.0 <- as.matrix(reslin.e$ghat)

  if(g.e.0 >= 50){                                         # start 28
   g.0 <- 100
  }else{                                                   # end 28, start 29
   g.0 <- NULL
  }                                                        # end 29

  res.star    <- nlm(star,x.e.0,hessian=TRUE,gradtol=1e-8,stepmax=1000,steptol=1e-6,iterlim=1000,dep=enso.dep,indep=enso.ind,indep.nl=enso.ind,tind=s.e,model=f.e,ghat=g.0)
  b.star      <- as.matrix(res.star$estimate)
}                                                          # end 27

hes.star    <- res.star$hessian
se.star     <- sqrt(diag(solve(hes.star,tol=1e-30)))
t.star      <- b.star/se.star
r.star      <- nrow(enso.ind)
m.star      <- nrow(as.matrix(b.star))
ndf.star    <- r.star-m.star
p.star      <- 2*pt(-abs(t.star),df=ndf.star)
restab.star <- cbind(b.star,se.star,t.star,p.star)

fit.star    <- star.pred(b.star,enso.dep,enso.ind,enso.ind,s.e,model=f.e,ghat=g.0)
pred.star   <- fit.star$pred
resid.star  <- fit.star$resid
trans.star  <- fit.star$trans
llk.star    <- fit.star$llk
aic.star    <- fit.star$aic

print(aic.star)

trans.e.mat <- cbind(s.e,trans.star)
trans.e.ord <- trans.e.mat[do.call("order",as.data.frame(trans.e.mat[,1])),]

b.e.1 <- b.star[(1):(2+p.e.d+11)]
b.e.2 <- b.star[((2+p.e.d+11)+1):(2*(2+p.e.d+11))]

if(is.null(g.0)){                                          # start 28   
  g.e   <- b.star[(2*(2+p.e.d+11)+1)]
  c.e   <- b.star[(2*(2+p.e.d+11)+2)]
  }else{                                                   # end 28, start 29
  g.e   <- 100
  c.e   <- b.star[(2*(2+p.e.d+11)+1)]
}                                                          # end 29 

# remaining nonlinearity
y0 <- resid.star
trans <- trans.star
tind.star <- s.e
sdtr <- apply(tind.star,2,sd)
ggt <- ((1+exp(-(g.e/sdtr)*(tind.star-c.e)))^(-2))*(exp(-(g.e/sdtr)*(tind.star-c.e)))*((tind.star-c.e)/sdtr)
gct <- ((1+exp(-(g.e/sdtr)*(tind.star-c.e)))^(-2))*(exp(-(g.e/sdtr)*(tind.star-c.e)))*(g.e/sdtr)
Xb  <- (enso.ind*matrix(trans,nrow(enso.ind),ncol(enso.ind)))
Xg  <- (enso.ind*matrix(ggt,nrow(enso.ind),ncol(enso.ind)))%*%(b.e.2)
Xc  <- (enso.ind*matrix(gct,nrow(enso.ind),ncol(enso.ind)))%*%(b.e.2)

if(g.e < 15){                                              # start 30
exog.mat.2 <- cbind(enso.ind,Xb,Xg,Xc)
}else{                                                     # end 30, start 31
exog.mat.2 <- cbind(enso.ind,Xb)
}                                                          # end 31

ter.e.2 <- terasvirta.test(y=y0,x=exog.mat.2,x.nl=enso.ind,tv=trans.var.enso,tv.lag=6,ascending=F)

nlin.e.2 <- as.matrix(ter.e.2$nl.mat[,1:4])
nlin.e.2.tab <- xtable(nlin.e.2)

trans.e.fun.ts <- ts(trans.star,start=c((1952),(m)),end=c((1991+d-1),(m-1)),frequency=12)
trans.e.var.ts <- ts(s.e,start=c((1952),(m)),end=c((1991+d-1),(m-1)),frequency=12)

if(m == 1){                                                # start 32
  png(filename=paste("Figures/ENSO_STAR_",1990+d-1,".png",sep=""),height=1600,width=3200,bg="white",res=300)
  par(mfrow=c(1,2), mar=c(5,4,1,3),oma=c(0,0,0,0),cex=1.2)
  plot(trans.e.fun.ts,col="#4488bb",type="l",lwd=2,lty=3,xlab="",ylab="",ylim=c(0,1),axes=FALSE)
  mtext(4,text=expression(paste("G","(","s"["t"],";",gamma,",","c",")")),line=3,cex=1.2)
  axis(4)
  par(new=TRUE)
  plot(trans.e.var.ts,type="l",col="#ddbb88",lwd=2,lty=1,xlab=expression(paste("t")),ylab=expression(paste("s"["t"])),ylim=c(-5,5))
  plot(trans.e.ord,type="p",pch=16,col="#4488bb",xlab=expression(paste("s"["t"])),ylab="",ylim=c(0,1))
  legend("bottomright",legend=c(expression(paste("s"["t"])),expression(paste("G","(","s"["t"],";",gamma,",","c",")"))),lty=c(1,3),lwd=c(2,2),col=c("#ddbb88","#4488bb"),horiz=F,bty="n",cex=1.2)
  dev.off()
}                                                          # end 32


skewness(resid.star)
kurtosis(resid.star)
jarque.bera.test(resid.star)

b.e.mat <- cbind(b.ar,b.e.1,b.e.2)
t.e.mat <- as.matrix(c(d.e,g.e,c.e,p.e,aic.ar2,aic.star))

write.table(b.e.mat,file=paste("Estimates/beta_e_",(1991+d-1),"_",(m-1),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)
write.table(t.e.mat,file=paste("Estimates/tran_e_",(1991+d-1),"_",(m-1),".txt",sep=""),quote=FALSE,sep=",",row.names=FALSE,col.names=FALSE)

write.table(nlin.e,file=paste("Estimates/ter1_e_",(1991+d-1),"_",(m-1),".txt",sep=""),quote=FALSE,sep=",",row.names=TRUE,col.names=TRUE)
write.table(nlin.e.2,file=paste("Estimates/ter2_e_",(1991+d-1),"_",(m-1),".txt",sep=""),quote=FALSE,sep=",",row.names=TRUE,col.names=TRUE)

star.e.1 <- as.matrix(t(c(as.numeric(nlin.e[d.e,]))))
star.e.2 <- as.matrix(t(c(as.numeric(nlin.e.2[d.e,]))))

write.table(star.e.1,file="Estimates/ter1_e.txt",quote=FALSE,sep=",",row.names=F,col.names=F,append=T)
write.table(star.e.2,file="Estimates/ter2_e.txt",quote=FALSE,sep=",",row.names=F,col.names=F,append=T)

}                                                          # end main loop B

print(c(p.e,d.e))

}                                                          # end main loop A

